/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.evolvedmekanism.recipes.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import fr.iglee42.evolvedmekanism.recipes.ChemixerRecipe;
import mekanism.api.SerializerHelper;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.Mekanism;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class ChemixerRecipeSerializer<RECIPE extends ChemixerRecipe>
implements RecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public ChemixerRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @NotNull
    public RECIPE fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
        JsonArray itemInput = GsonHelper.m_13885_((JsonObject)json, (String)"mainInput") ? GsonHelper.m_13933_((JsonObject)json, (String)"mainInput") : GsonHelper.m_13930_((JsonObject)json, (String)"mainInput");
        ItemStackIngredient solidIngredient = (ItemStackIngredient)IngredientCreatorAccess.item().deserialize((JsonElement)itemInput);
        JsonArray extraInput = GsonHelper.m_13885_((JsonObject)json, (String)"extraInput") ? GsonHelper.m_13933_((JsonObject)json, (String)"extraInput") : GsonHelper.m_13930_((JsonObject)json, (String)"extraInput");
        ItemStackIngredient extraIngredient = (ItemStackIngredient)IngredientCreatorAccess.item().deserialize((JsonElement)extraInput);
        JsonArray gasInput = GsonHelper.m_13885_((JsonObject)json, (String)"gasInput") ? GsonHelper.m_13933_((JsonObject)json, (String)"gasInput") : GsonHelper.m_13930_((JsonObject)json, (String)"gasInput");
        ChemicalStackIngredient.GasStackIngredient gasIngredient = (ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().deserialize((JsonElement)gasInput);
        ItemStack output = SerializerHelper.getItemStack((JsonObject)json, (String)"output");
        if (output.m_41619_()) {
            throw new JsonSyntaxException("Chemixer recipe output must not be empty.");
        }
        return this.factory.create(recipeId, solidIngredient, extraIngredient, gasIngredient, output);
    }

    public RECIPE fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
        try {
            ItemStackIngredient inputSolid = (ItemStackIngredient)IngredientCreatorAccess.item().read(buffer);
            ItemStackIngredient inputExtra = (ItemStackIngredient)IngredientCreatorAccess.item().read(buffer);
            ChemicalStackIngredient.GasStackIngredient inputGas = (ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().read(buffer);
            ItemStack outputItem = buffer.m_130267_();
            return this.factory.create(recipeId, inputSolid, inputExtra, inputGas, outputItem);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading chemixer recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull RECIPE recipe) {
        try {
            ((ChemixerRecipe)((Object)recipe)).write(buffer);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing chemixer recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends ChemixerRecipe> {
        public RECIPE create(ResourceLocation var1, ItemStackIngredient var2, ItemStackIngredient var3, ChemicalStackIngredient.GasStackIngredient var4, ItemStack var5);
    }
}

